/* eslint-disable no-undef, no-unused-vars */
/* global sc */

// OCR text extraction utilities

function moduleFunction(config) {
  // Initialize $$ with provided config or default
  let $$ = config || require('./debug')({ debug: 'cache', path: module.id });

  let objects = require('common/objects').sc($$.environment.context || sc);
  let force = null;

  try {
    let text = require('common/text');
    
    /**
     * Forces OCR text extraction on a document
     * 
     * @param {string} id - Object ID or path
     * @param {Object} [parameters] - Optional extraction parameters
     * @returns {string} - Extracted text
     */
    function forceExtraction(id, parameters) {
      let obj = objects.find(id);
      return text.extract(obj, {
        extractionType: text.EXTRACTION_TYPES.FORCE,
        parameters: parameters,
        forceOcr: true,
      });
    }
    
    force = forceExtraction;
    
  } catch (e) {
    force = function() { 
      throw new Error('ocr.force not available in this agorum revision'); 
    };
  }

  // Return the module functions
  return {
    force: force
  };
}

// Initialize $$ when the module is required without parameters
let moduleExports = moduleFunction();

// Export the module function and its methods
module.exports = Object.assign(moduleFunction, moduleExports);
